/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class Button
implements Part {
    private String title = null;
    private String icon = null;
    private Action action = null;
    private Object context = null;
    private boolean isDefault = false;
    private boolean enabled = true;
    protected org.eclipse.swt.widgets.Button button = null;

    public Button(String title, Action action) {
        this(title, action, null, false);
    }

    public Button(String title, Action action, Object context) {
        this(title, action, context, false);
    }

    public Button(String title, Action action, Object context, boolean defaultButton) {
        this(title, action, context, defaultButton, null);
    }

    public Button(String title, Action action, Object context, boolean defaultButton, String icon) {
        this.title = title;
        this.action = action;
        this.context = context;
        this.isDefault = defaultButton;
        this.icon = icon;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(this.enabled);
        }
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        this.title = text;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setText(this.title);
        }
    }

    public void setIcon(String icon) {
        this.icon = icon;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setImage(this.icon != null ? SWTUtil.getImage(this.icon) : null);
        }
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        this.button = GUI.getStyleFactory().createButton(parent);
        this.button.setText(this.title == null ? "" : this.title);
        this.button.setLayoutData((Object)new GridData(128));
        if (this.icon != null) {
            this.button.setImage(SWTUtil.getImage(this.icon));
        }
        try {
            if (this.isDefault) {
                parent.getShell().setDefaultButton(this.button);
            }
        }
        catch (IllegalArgumentException ae) {
            try {
                GUI.getShell().setDefaultButton(this.button);
            }
            catch (IllegalArgumentException ae2) {
                Logger.warn((String)("unable to set default button: " + ae2.getLocalizedMessage()));
            }
        }
        this.button.setEnabled(this.enabled);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GUI.startSync(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Button.this.action.handleAction(Button.this.context);
                        }
                        catch (ApplicationException e) {
                            Application.getMessagingFactory().sendMessage(new StatusBarMessage(e.getMessage(), 1));
                        }
                    }
                });
            }
        });
    }
}

